package eqsolver.ui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

import eqsolver.*;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolutionPanel extends JPanel {

	JButton solve = new JButton("Solve");
	JLabel resultLabel = new JLabel();
	private ProxyEquation equation;

	public SolutionPanel(ProxyEquation equation) {
		this.equation = equation;

		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new GridLayout(3, 1));
		JLabel infoLabel = new JLabel("Soluzioni");

		solve.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {

				esegui();
			}
		});

		add(infoLabel);
		add(solve);
		add(resultLabel);

	}

	public void esegui() {

		
		
		float[] tmp = equation.getSol();
		
		System.out.println("da solution panel prametri "+equation.getParam()[0]+" "+equation.getParam()[1]);
		System.out.println("da solution panel "+tmp[0]+" ");
		

		String ris = " ";

		for (int i = 0; i < tmp.length; i++) {
			ris += "x_" + i + "=" + tmp[i] + " ";
		}
		
		System.out.println(ris);

		resultLabel.setText(ris);

	}

}
